/**
 * \file keyman_caam.h
 *
 * \brief IMX6 specific header for keyman
 *
 * \author Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef __LIBKEYMAN_ARCH_IMX_H_
#define __LIBKEYMAN_ARCH_IMX_H_

#include <linux/caam_km.h>
#include <private/base64.h>

#define KEYMAN_KEYMAN_DEVICE    ("/dev/" CAAM_KM_DEV_NAME)

/* used to define that the library expects a certain
 * version-subversion for correct operation
 */
#define LIBKEYMAN_FEATURE_VERSION       3
#define LIBKEYMAN_FEATURE_SUBVERSION    3

#define VERSION_INFO_STR_MAX 256


/* estimation of the length needed for base64 encoding */
#define BLOB_B64_LEN    (B64_ENC_LEN(CAAM_KM_ENCAP_KEY_SIZE_MAX))
#define BLOB_LEN        (CAAM_KM_ENCAP_KEY_SIZE_MAX)

struct disc_key_ext {
    uint32_t key_flags;
    uint32_t key_bits;
    struct caam_key_perms perms;
    uint32_t modifier_bytes; /* currently always 0 */
    uint32_t add_data_bytes; /* currently always 0 */
};

#define EXT_LEN         ((ssize_t)sizeof(struct disc_key_ext))
#define EXT_B64_LEN     (B64_ENC_LEN(EXT_LEN))

union disc_key_extension_union {
    struct disc_key_ext as_struct;
    /** sizeof disc_key_ext + additional \0 */
    uint8_t as_bytes[EXT_LEN + 1];
};

/** Memory repersentation of a disc stored key entry */
struct disc_key {
    uint32_t kid;           /**< Key ID */
    uint32_t uid;           /**< User ID */
    uint32_t gid;           /**< Group ID */

    /** Base64 encoded blob */
    uint8_t blob_b64[BLOB_B64_LEN + 1];

    uint32_t blob_len; /**< Length of blob */
    /** Buffer to store the blob + additional \0 */
    uint8_t blob[BLOB_LEN + 1];

    bool with_ext; /* does the key have ext data */
    union disc_key_extension_union ext; /* ext data */
    uint8_t ext_b64[EXT_B64_LEN + 1]; /* base64 encoded ext data */
};

/* architecture dependent libkeyman ctx */
struct libkeyman_ctx {
    struct disc_key *disc_keys;
    size_t disc_keys_num;
};

#endif
